﻿var ADMIN_USER = 0;
var POWER_USER = 1;
var USER = 2;
var ENGLISH = 0;
var CHINESE = 1;

function mouseOverNormal(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn2_hover.png)";
	}
}
function mouseOutNormal(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn2_normal.png)";
	}
}

function mouseOverSpec(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_hover.png)";
	}
}

function mouseOutSpec(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_normal.png)";
	}
}

function disabledButton(obj, flag)
{
	obj.disabled = flag;
	if(flag == true)
	{
		obj.style.color = "#666";
		obj.style.cursor = "auto";
	}
	else
	{
		obj.style.color = "#584693";
		obj.style.cursor = "pointer";
	}
	
}
function adminDisplay(group, obj)
{
	if(group == ADMIN_USER)
	{
		obj.style.display = "";
	}
	else
	{
		obj.style.display = "none";
	}
}

function applyDispay(group, obj)
{
	if(group == USER)
	{
		obj.style.display = "none";
	}
	else
	{
		obj.style.display = "";
	}
}

function applyDispay(group, obj)
{
	if(group == USER)
	{
		obj.style.display = "none";
	}
	else
	{
		obj.style.display = "";
	}
}

function getTreeIdCh(treeId)
{
	var treeIdCh = "";
	switch(treeId)
	{
		case "Monitor":
		{
			treeIdCh = "监测信息";
			break;
		}
		case "Alarms":
		{
			treeIdCh = "告警信息";
			break;
		}
		case "Cards":
		{
			treeIdCh = "接口设置";
			break;
		}
		case "Maps":
		{
			treeIdCh = "映射表设置";
			break;
		}
		case "Scramb":
		{
			treeIdCh = "加扰设置";
			break;
		}
		case "System":
		{
			treeIdCh = "系统设置";
			break;
		}
		case "Mux":
		{
			treeIdCh = "PSI/SI复用";
			break;
		}
		default:
		{
			break;
		}
	}
	return treeIdCh;
}

function getAlarmSeveritCh(severity)
{
	var severityCh;
	switch(severity)
	{
		case "Urgency":
		{
			severityCh = "紧急告警";
			break;
		}
		case "Major":
		{
			severityCh = "主要告警";
			break;
		}
		case "Minor":
		{
			severityCh = "次要告警";
			break;
		}
		case "Info":
		{
			severityCh = "提示告警";
			break;
		}
		default:
		{
			break;
		}
	}
	return severityCh;
}

function getArgs() 
{
    var args = new Object();
    var query = location.search.substring(1);     // Get query string
    var pairs = query.split("&");                 // Break at ampersand
    for(var i = 0; i < pairs.length; i++) 
	{
        var pos = pairs[i].indexOf('=');          // Look for "name=value"
        if(pos == -1) 
		{
			continue;                  // If not found, skip
		}
        var argname = pairs[i].substring(0, pos);  // Extract the name
        var value = pairs[i].substring(pos + 1);    // Extract the value
        value = decodeURIComponent(value);        // Decode it, if needed
        args[argname] = value;                    // Store as a property
    }
    return args;                                  // Return the object
} 
/*************************************************
Function:  		ValidateParam
Description:  	非IP类参数校验，弹出校验结果，输入无效则聚焦
Input:  		obj: current param jquery object; 
				type: param type; 
				minValue: min value; 
				maxValue: max value; 
				str1: English param name; 
				str2: Chinese param name;
				language: current page language, 1-English; 2-Chinese
Output:			无
Return:  		if validate, return ture; else, return false
Others: 		minValue and maxValue both 0, value is no range
				when type is "LENGTH", minValue and maxValue are the length value
*************************************************/
function ValidateParam(obj, type, minValue, maxValue, str1, str2, language)
{
	var patten;
	var strVal = obj.val();
	var numVal;
	var minValDisplay;
	var maxValDisplay;
	switch(type) 
	{
		case "INT_DEC":  //十进制整数
			patten = /^-?\d+$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a decimal integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十进制整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_DEC_HEX":  //十进制或十六进制（以0x或0X开头），非负整数
			patten = /(^\d+$)|(^0[xX]([A-Fa-f0-9])+$)/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a non-negative integer(decimal or hexadecimal which starts with 0x or 0X)!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是非负整数（十进制或者十六进制，其中十六进制数以0x或0X起始）！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_HEX":  //十六进制非负整数
			patten = /^([A-Fa-f0-9])+$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a hexadecimal non-negative integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十六进制非负整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "INT_HEX_NULL":  //十六进制非负整数，可以为空
			patten = /^([A-Fa-f0-9])*$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " should be a hexadecimal non-negative integer!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该是十六进制非负整数！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false; 
			}
			break;
			
		case "LENGTH":  //只对长度有要求
			if(language == CHINESE)
			{
				var strLength = strVal.replace(/[^\x00-\xff]/g,'***').length;
			}
			else
			{
				var strLength = strVal.length;
			}
			if(minValue == maxValue)  //Length is fixed
			{
				if(strLength != minValue)
				{
					if(language == ENGLISH)
					{
						alert("The length of " + str1 + " should be " + minValue + "!");
					}
					else if(language == CHINESE)
					{
						alert(str2 + "长度应该为 " + minValue + "！");
					}
					setTimeout(function () {obj.focus()}, 0);
					setTimeout(function () {obj.select()}, 0);
					return false;
				}
			}
			else
			{
				if((strLength < minValue) || (strLength > maxValue))  //长度范围
				{
					if(language == ENGLISH)
					{
						alert("The length of " + str1 + " should be between " + minValue + " and " + maxValue + "!");
					}
					else if(language == CHINESE)
					{
						alert(str2 + "长度应该在 " + minValue + "和" + maxValue + "之间！");
					}			
					setTimeout(function () {obj.focus()}, 0);
					setTimeout(function () {obj.select()}, 0);
					return false;
				}
			} 
			break;
			
		case "FLOATING":  //非负浮点数
			var patten  = /^\d+(\.\d+)?$/;
			if(!patten.test(strVal))
			{
				if(language == ENGLISH)
				{
					alert(str1 + " Please input a valid number!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "请输入合法的数字！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false;
			}
			break;
		default:
			break;
	}
	if(type != "LENGTH")  //数值范围，非长度范围
	{
		if((type == "INT_DEC") || (type == "INT_DEC_HEX"))  //可输入十进制的整数
		{
			var ch = strVal.slice(0, 2);
			if((ch == "0x") || (ch == "0X"))  //十六进制
			{
				numVal = parseInt(strVal, 16);
			}
			else  //十进制
			{
				numVal = parseInt(strVal, 10);
			}
		}
		else if((type == "INT_HEX") || (type == "INT_HEX_NULL"))  //纯十六进制整数
		{
			if(strVal == "")
			{
				return true;
			}
			numVal = parseInt(strVal, 16);
		}
		else if(type == "FLOATING") //浮点数
		{
			numVal = parseFloat(strVal);
		}
		if((minValue < maxValue) || ((minValue > 0) && (minValue == maxValue))) //有数值范围,主千兆卡端口添加告警可能范围是[1,1]，输入0,0表示参数没有取值范围
		{
			if((numVal < minValue) || (numVal > maxValue))
			{
				if(type == "INT_DEC_HEX")
				{
					minValDisplay = minValue + "(0x" + minValue.toString(16) + ")";
					maxValDisplay = maxValue + "(0x" + maxValue.toString(16) + ")";
				}
				else if((type == "INT_HEX") || (type == "INT_HEX_NULL"))
				{
					minValDisplay = "0x" + minValue;
					maxValDisplay = "0x" + maxValue;
				}
				else
				{
					minValDisplay = minValue;
					maxValDisplay = maxValue;
				}
				if(language == ENGLISH)
				{
					alert(str1 + " should be between " + minValDisplay + " and " + maxValDisplay + "!");
				}
				else if(language == CHINESE)
				{
					alert(str2 + "应该在" + minValDisplay + "和" + maxValDisplay + "之间！");
				}
				setTimeout(function () {obj.focus()}, 0);
				setTimeout(function () {obj.select()}, 0);
				return false;
			}
		}
	}
	return true; 
}
function validateAccuracy(value, num)
{
	var pieces = value.toString().split(".");
	if((pieces.length > 1) && (pieces[1].length > num))
	{
		return false;
	}
	return true;
}

function getHTTPObject()
{
	var aHttpObject = false;
	try
	{
		aHttpObject = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch(e)
	{
		try
		{
			aHttpObject = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch(E)
		{
			aHttpObject = false;
		}
	}
	if ((!aHttpObject) && (typeof XMLHttpRequest != "undefined"))
	{
		try
		{
			aHttpObject = new XMLHttpRequest();
		}
		catch(e)
		{
			aHttpObject = false;
		}
	}

	return aHttpObject;
}

function validateString(value, length, language)
{
	if(value == "")
	{
		if(language == 0)
		{
			alert("The input is empty!");
		}
		else
		{
			alert("输入为空!");
		}
		return false;
	}
	if(value.length > length)
	{
		if(language == 0)
		{
			alert("The digit number of the input is no more than " + length + "!");
		}
		else
		{
			alert("输入应小于" + length + "位！");
		}
		return false;
	}
	var str = /^[^A-Za-z0-9]+$/;
	if(str.test(value))
	{
		if(language == 0)
		{
			alert("The input should consist of only letter,integer!");
		}
		else
		{
			alert("输入只能由字母（区分大小写）、数字组成！");
		}
		return false;
	}
	return true;
}

function validID(Id, language)
{
	var patten = /(^\d+$)|(^0[xX]([A-Fa-f0-9])+$)/;
	if(!patten.test(Id))
	{
		if(language == 0)
		{
			alert("The ID should be non-negative integer(decimal or Hexadecimal which starts with 0x or 0X)!");
		}
		else
		{
			alert("输入ID应该是非负整数（十进制或者十六进制，其中十六进制数以0x或0X起始）！");
		}
		return false;
	}
	return true;
}

/*****校验登录名：只能输入3-20位字母（区分大小写,QAM Group Name不需要限制位数最低值，只要不为空就行）、数字或下划线组成的字串 ，不能以下划线作为开头和结尾*****/
/*type: 0：其它name；1：QAM Group Name**/
/*language: 0：English；1：Chinese*/
function validateName(name, type, language)
{	
	if(type == 0)
	{
		if(name.length < 3)
		{
			if(language == 0)
			{
				alert("The digit number of the name is no less than 3!");
			}
			else
			{
				alert("输入名字应大于3位！");
			}
			return false;
		}
	}
	else
	{
		if(name == "")
		{
			if(language == 0)
			{
				alert("The name is empty!");
			}
			else
			{
				alert("输入名字为空!");
			}
			return false;
		}
	}
	if(name.length > 20)
	{
		if(language == 0)
		{
			alert("The digit number of the name is no more than 20!");
		}
		else
		{
			alert("输入名字应小于20位！");
		}
		return false;
	}
	
	var str = /[^\w]/;
	if(str.test(name))
	{
		if(language == 0)
		{
			alert("The name should consist of only letter,integer or underline!");
		}
		else
		{
			alert("输入名字只能由字母（区分大小写）、数字或下划线组成！");
		}
		return false;
	}
	
	var str = /^[_]|[_]$/;
	if(str.test(name))
	{
		if(language == 0)
		{
			alert("Underline can not as a beginning or an ending of the name!");
		}
		else
		{
			alert("输入名字不能以下划线作为开头和结尾！");
		}
		
		return false;
	}
	return true;	
}

/*************************************************
Function:  		IPCompare
Description:  	校验两个IP地址是否相等
Input:  		ipString1,ipString2: 需要校验的值
Output:			无
Return:  		如果相等 return ture; 否则 return false
Others: 		无
*************************************************/
function IPCompare(ipString1, ipString2)
{
	var ipArray1 = ipString1.split(".");
	var ipArray2 = ipString2.split(".");
	if((parseInt(ipArray1[0],10) == parseInt(ipArray2[0],10)) && (parseInt(ipArray1[1],10) == parseInt(ipArray2[1],10)) && (parseInt(ipArray1[2],10) == parseInt(ipArray2[2],10)) && (parseInt(ipArray1[3],10) == parseInt(ipArray2[3],10)))
	{
		return true;
	}
	else
	{
		return false;
	}
}

function Validate_IP_Format(IPAddress)
{
	var IPAddr_Fields = IPAddress.split(".");
	var Field_Value;
	
	// make sure there are 4 octets
	if(IPAddr_Fields.length != 4)
	{
		return false;
	}
	for(var i = 0; i < IPAddr_Fields.length; i++)
	{
		if(validateNumber(IPAddr_Fields[i]) == false)
		{
			return false;
		}
		Field_Value = parseInt(IPAddr_Fields[i], 10);
		if((Field_Value < 0) || (Field_Value > 255))
		{
			return false;
		}
	}
	
	return true;
}

function Validate_IPAddress(IPAddress)
{
	var IPAddr_Fields = IPAddress.split(".");
	
	if(Validate_IP_Format(IPAddress) == false)
	{
		return false;
	}
	
	if((IPAddr_Fields[0] < 1) || (IPAddr_Fields[0] > 223) || (IPAddr_Fields[0] == 127))
	{
		return false;
	}
	return true;
}

//IP转成无符号数值
function IP2Num(ip) 
{
    var num = 0;
    ip = ip.split(".");
    num = Number(ip[0]) * 256 * 256 * 256 + Number(ip[1]) * 256 * 256 + Number(ip[2]) * 256 + Number(ip[3]);
    num = num >>> 0;
    return num;
}

//无符号转成IP地址
function Num2IP(num) 
{
    var str;
    var tt = new Array();
    tt[0] = (num >>> 24) >>> 0;
    tt[1] = ((num << 8) >>> 24) >>> 0;
    tt[2] = (num << 16) >>> 24;
    tt[3] = (num << 24) >>> 24;
    str = String(tt[0]) + "." + String(tt[1]) + "." + String(tt[2]) + "." + String(tt[3]);
    return str;
}

function Valid_Mask(mask)
{
    var flag = -1;
    var tt = IP2Num(mask);
    var str = tt.toString(2);
	
	if(Validate_IP_Format(mask) == false)
	{
		return false;
	}
	/*
    var reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])(\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])){3}$/;
    if(reg.test(mask) == false)
	{
        return false;
	}
	*/
	if(tt == 0)
	{
		return false; 
	}
    for(var i = 0; i < str.length; i++) 
    {
        if(str.charAt(i) == "0")
		{
            flag = i;
		}
        if((str.charAt(i) == "1") && (flag > -1))
		{
            return false;
		}
    }
    return true;
}

function Validate_Subnet(IPAddress, SubnetMask)
{
	var ipAddr;
	var mask;
	var networkByte;
	var antiMask;
	
	ipAddr = IP2Num(IPAddress);
	mask = IP2Num(SubnetMask);
	networkByte = ipAddr & (~mask);
	antiMask = ~mask;
	if((networkByte == 0) || (networkByte == antiMask))
	{
		return false;
	}
	return true;
}

/* This method checks if a given set of host IP and gateway IP fall in the 
 * same network. 
 * Call this only after verifying the given values are in proper IP format. 
 * Also make sure that the mask is a proper mask.
 * This method does not internally validate IP addresses and mask. 
 */ 
function Valid_Gateway(ip, mask, gateway)
{
    var ip_num, gateway_num, mask_num, ip_mask, gw_mask;
    ip_num = IP2Num(ip);
    gateway_num = IP2Num(gateway);
    mask_num = IP2Num(mask);
    ip_mask = (ip_num & mask_num)>>>0;
    gw_mask = (gateway_num & mask_num)>>>0;
    if(ip_mask != gw_mask)
	{
        return false;
	}
    return true;
}


function validateNumber(input)
{
	var len = input.length;

	if(len == 0)
	{
		return false;
	}

	for(index = 0; index < len; index++)
	{
		if(isNaN(parseInt(input.charAt(index))))
		{
			return false;
		}
	}

	return true;
}

function validateFloat(input)
{
	var len = input.length;

	if(len == 0)
	{
		return false;
	}
	if(isNaN(input))
	{
		return false;
	}
	return true;
}

//JavaScript转码函数
function gb2utf8(data)
{
	var glbEncode = [];
	gb2utf8_data = data;
	execScript("gb2utf8_data = MidB(gb2utf8_data, 1)", "VBScript");
	var t = escape(gb2utf8_data).replace(/%u/g,"").replace(/(.{2})(.{2})/g,"%$2%$1").replace(/%([A-Z].)%(.{2})/g,"@$1$2");
	t = t.split("@");
	var i = 0, j = t.length, k;
	while(++i<j) 
	{
		k = t[i].substring(0,4);
		if(!glbEncode[k]) 
		{
			gb2utf8_char = eval("0x"+k);
			execScript("gb2utf8_char = Chr(gb2utf8_char)", "VBScript");
			glbEncode[k] = escape(gb2utf8_char).substring(1,6);
		}
		t[i] = glbEncode[k]+t[i].substring(4);
	}
	gb2utf8_data = gb2utf8_char = null;
	return unescape(t.join("%"));
}


/*
function getDivisor(value)
{
	var max = parseInt(value, 10);

	if(max < 1000)
	{
		return 1;
	}
	if(max < 1000000)
	{
		return 1000;
	}
	if(max < 1000000000)
	{
		return 1000000;
	}
	return 1000000000;
}

function fixAtTwoDecimals2(anynum)
{
	return parseFloat(parseInt(anynum * 100, 10) / 100);
}

function CheckIpRange(elem)
{
	if((document.getElementById(elem).value < 0) ||
		(document.getElementById(elem).value > 255) ||
	    (document.getElementById(elem).value == ""))
	{
	 	alert("Invalid IP Address!");
	 	document.getElementById(elem).value = "0";
	 	return false;
	}
	return true;
}


function isValidMacAddress(macAdd)
{
	var RegExPattern = /^[0-9a-fA-F:]+$/;

	if((!(macAdd.match(RegExPattern))) || (macAdd.length != 17))
	{
		if(macAdd.length != 0)
		{
			return false;
		}
	}
	else
	{
		var splitString = macAdd.split(":");

		for(var i = 0; i < 6; i++)
		{
			if(splitString[i].length != 2)
			{
				alert("Invalid MAC address. Please enter a valid MAC address.");
				return false;
			}
		}
	}
	return true;
}

*/
